resource "iosxe_rest" "HOSTNAME_PUT" {
  method = "PUT"
  path   = "/data/Cisco-IOS-XE-native:native/hostname"
  payload = jsonencode(
    {
      "Cisco-IOS-XE-native:hostname" : "from_terraform"
    }
  )
}

resource "iosxe_rest" "ACL_POST" {
  method = "POST"
  path   = "/data/Cisco-IOS-XE-native:native/ip/access-list"
  payload = jsonencode(
    {
      "Cisco-IOS-XE-acl:extended" : [
        {
          "name" : "ACL",
          "access-list-seq-rule" : [
            {
              "sequence" : "10",
              "ace-rule" : {
                "action" : "permit",
                "protocol" : "ip",
                "host" : "10.1.1.4",
                "dst-any" : [
                  null
                ]
              }
            },
            {
              "sequence" : "20",
              "ace-rule" : {
                "action" : "permit",
                "protocol" : "tcp",
                "any" : [
                  null
                ],
                "dst-any" : [
                  null
                ],
                "dst-eq" : 80
              }
            }
          ]
        }
      ]
    }
  )
}

resource "iosxe_rest" "NAT_PUT" {
  method = "PATCH"
  path   = "/data/Cisco-IOS-XE-native:native/ip/nat"
  payload = jsonencode(
    {
      "Cisco-IOS-XE-nat:nat" : {
        "pool" : [
          {
            "id" : "natpool",
            "prefix-length" : 27
          }
        ],
        "inside" : {
          "source" : {
            "list" : [
              {
                "id" : 1,
                "pool" : "natpool"
              }
            ]
          }
        }
      }
    }
  )
}


resource "iosxe_rest" "OSPF_POST" {
  method = "POST"
  path   = "/data/Cisco-IOS-XE-native:native/router"
  payload = jsonencode(
    {
      "Cisco-IOS-XE-ospf:ospf" : [
        {
          "id" : 123,
          "network" : [
            {
              "ip" : "10.1.1.0",
              "mask" : "0.0.0.15",
              "area" : 20
            },
            {
              "ip" : "10.22.22.0",
              "mask" : "0.0.0.255",
              "area" : 22
            }
          ]
        }
      ]
    }
  )
}
