terraform {
  required_providers {
    docker = {
      source  = "kreuzwerker/docker"
      version = "~> 3.0.1"
    }
  }
}

provider "docker" {}

resource "docker_image" "nginx" {
  name         = "nginx"
  keep_locally = false
}

resource "docker_container" "nginx" {
  image = docker_image.nginx.image_id
  name  = "testContanierTerraform"

  ports {
    internal = 80
    external = 8000
  }

  volumes {
    container_path = "/data"
    host_path      = "${path.cwd}/data"
  }
}
