from netmiko import ConnectHandler

def connect(ip_add):
  ssh_conn = ConnectHandler(
    host=ip_add,
    port='22',
    username='cisco',
    password='cisco123!',
    device_type='cisco_ios'
    )
  return ssh_conn


if __name__ == "__main__":
  router_connection = connect("147.232.48.41")
  router_connection.enable()

  hostname = router_connection.send_command('show run | inc hostname')
  print(hostname)
  print('\n ################## \n')

  router_connection.config_mode()

  router_connection.send_command('hostname from_netmiko_final')

  router_connection.exit_config_mode()

  show_hostname = router_connection.send_command('show run | inc hostname', expect_string=r'#', read_timeout=90)
  print(show_hostname)

  router_connection.disconnect()
