from scapy.layers.inet import IP
from scapy.packet import Raw
from scapy.sendrecv import sniff

# odchytenie 5 ICMP správ a vytvorenie poľa pre ukladanie kľúčových charakteristík
packets = sniff(filter="icmp", count= 5)
rcv_data = []

#cyklus, ktorý prejde každou odchytenou ICMP správou
for packet in range(0, 5):
    #do JSON podoby uloží hľadané charakteristiky (zdrojová/cieľová adresa a payload)
    packet_info = {
        "src_address": packets[packet][IP].src,
        "dst_address": packets[packet][IP].dst,
        "payload": packets[packet][Raw].load.decode('utf-8','ignore')
    }
    #uloženie dát do vytvoreného poľa
    rcv_data.append(packet_info)
#výpis obsahu odchytených dát
for i in range(0, len(rcv_data)):
  print(str(rcv_data[i])+"\n")
