#importovanie knižnice SCAPY pre prácu s ICMP, IP protokolom a na odosielanie dát
from scapy.layers.inet import ICMP, IP
from scapy.sendrecv import sr1

#funkcia na odoslanie jednej ICMP správy, pričom používateľ definuje adresy a obsah
def send_one_ICMP_MSG(src_address, dst_address, payload):
    #vytvorenie dátovej jednotky = default IP + default ICMP + payload
    icmp = IP() / ICMP() / payload
    #úprava atribútov IP hlavičky
    icmp[IP].src = src_address
    icmp[IP].dst = dst_address
    #odoslanie požiadaviek
    resp = sr1(icmp, timeout=2)
    print(resp)

#funkcia na odoslanie viacerých ICMP správ, pričom používateľ definuje adresy, obsah a počet
def send_several_ICMP_MSG(src_address, dst_address, payload, count):
    #vytvorenie dátovej jednotky = default IP + default ICMP + payload
    icmp = IP() / ICMP() / payload
    #úprava atribútov IP hlavičky
    icmp[IP].src = src_address
    icmp[IP].dst = dst_address
    #cyklus, ktorý zopakuje odoslanie ICMP správy toľko krát, koľko to definoval používateľ
    for num in range(0, count):
        #odoslanie požiadaviek
        resp = sr1(icmp, timeout=2)
        print(resp)

if __name__ == '__main__':
    #volanie vytvorených funkcii
    send_one_ICMP_MSG("10.10.10.19", "10.10.10.1", "Secret_MSG123")
    #send_several_ICMP_MSG("10.10.10.19", "10.10.10.1", "Secret_MSG", 10)