#importovanie knižnice SCAPY pre prácu s protokolom IP, obsahom prenášaných správ a odchytávania prevádzky zo sieťovej karty
from scapy.layers.inet import IP
from scapy.packet import Raw
from scapy.sendrecv import sniff
#importovanie knižnice pre prácu s JSON dátami
import json

if __name__ == '__main__':
    #odchytenie 5 ICMP správ a vytvorenie poľa pre ukladanie kľúčových charakteristík
    packets = sniff(filter="icmp", count= 5)
    rcv_data = []
    #cyklus, ktorý prejde každou odchytenou ICMP správou
    for packet in range(0, 5):
        #do JSON podoby uloží hľadané charakteristiky (zdrojová/cieľová adresa a payload)
        packet_info = {
            "src_address": packets[packet][IP].src,
            "dst_address": packets[packet][IP].dst,
            "payload": packets[packet][Raw].load.decode()
        }
        #uloženie dát do vytvoreného poľa
        rcv_data.append(packet_info)

    #výpis obsahu odchytených dát
    print(json.dumps(rcv_data, indent=2))