#import knižníc pre prácu s JSON a HTTP protokolom a akceptovanie self-signed certifikátov
import json
import requests
requests.packages.urllib3.disable_warnings()

if __name__ == '__main__':
   #sekcia, ktorá vytvorí http správu na komunikáciu s RESTCONF API
   url = "https://10.10.10.15:443/restconf/data/native/router/ospf"
   payload = {}
   headers = {
      'Accept': 'application/yang-data+json',
      'Content-Type': 'application/yang-data+json',
      'Authorization': 'Basic Y2lzY286Y2lzY28xMjMh'
   }

   #sekcia, ktorá pošle GET žiadosť a prevedie prijaté dáta do dict(JSON object) štruktúry
   get_result = requests.request("GET", url, headers=headers, data=payload, verify=False)
   json_data = get_result.json()

   #výpis prijatých dát + výpis network konfigurácie protokolu OSPF
   print(json.dumps(json_data, indent = 2))
   print("\nSiete protokolu OSPF sú: \n")

   #získanie z JSON dát len network časti
   network_array = json_data["Cisco-IOS-XE-ospf:ospf"][0]["network"]

   #cyklus, ktorý prejde každým network záznamom a vypíše o ňom základné informácie
   for network in network_array:
      print("Sieť: ["+ network["ip"] + "]  Maska: [" + network["mask"] + "]  Oblasť: [" + str(network["area"]) +"]")