#importovanie knižnice pre tvorbu grafického rozhrania
from tkinter import *
#import knižníc pre prácu s JSON a HTTP protokolom a akceptovanie self-signed certifikátov
import json
import requests
requests.packages.urllib3.disable_warnings()

#funkcia pre načítanie názvu zariadenia
def get_hostname():
    url = "https://"+ip_address_value.get()+"/restconf/data/native/hostname"
    payload = {}
    headers = {
        'Accept': 'application/yang-data+json',
        'Content-Type': 'application/yang-data+json',
        'Authorization': 'Basic Y2lzY286Y2lzY28xMjMh'
    }
    #sekcia, ktorá pošle GET žiadosť a prevedie prijaté dáta do dict(JSON object) štruktúry
    get_result = requests.request("GET", url, headers=headers, data=payload, verify=False)
    json_data = get_result.json()
    #overenie návratovej hodnoty GET operácie a zmena obsahu Label značky pre výpis získaného názvu
    if get_result.status_code == 200:
        readed_name.set(json_data["Cisco-IOS-XE-native:hostname"])

#funkcia pre zmenu názvu zariadenia
def set_hostname():
    url = "https://" + ip_address_value.get() + "/restconf/data/native/hostname"
    payload = {"Cisco-IOS-XE-native:hostname": hostname_value.get()}
    headers = {
        'Accept': 'application/yang-data+json',
        'Content-Type': 'application/yang-data+json',
        'Authorization': 'Basic Y2lzY286Y2lzY28xMjMh'
    }
    #sekcia, ktorá pošle PUT žiadosť
    new_put = requests.request("PUT", url, headers=headers, data=json.dumps(payload), verify=False)
    #vypísanie notifikácie o úspešnosti zmeny názvu zariadenia
    if new_put.status_code == 204:
        status.set("Zmena úspešná :)")
        hostname_value.set("")
    else:
        status.set("Zmena neúspešná :'(")


if __name__ == '__main__':
    #vytvorenie objektu reprezentujúceho okno aplikácie a nastavenie jeho názvu a rozmerov
    root = Tk()
    root.title("Manage Hostname")
    root.geometry("420x150")

    #vytvorenie premenných pre uchovávanie používateľského vstupu
    ip_address_value = StringVar()
    hostname_value = StringVar()

    #vytvorenie značky pre názov aplikácie - v rámci rozhrania
    Label(root, text="Aplikácia pre správu názvu zariadenia", font=("Calibri bold", 19), fg="SteelBlue").grid(columnspan=5, row=0)
    #vytvorenie značky a elementu pre získanie používateľského vstupu
    Label(root, text="Set IP Address:").grid(columnspan=4, row=2)
    Entry(root, textvariable=ip_address_value, bg="LightSteelBlue").grid(columnspan=4, row=3)

    #vytvorenie značky pre výpis názvu zariadenia
    Label(root, text="Názov zariadenia je: ").grid(column=1, row=7)
    #vytvorenie premennej, ktorá bude niesť načítaný názov - bude aktualizovaná vo funkcii get_hostname()
    readed_name = StringVar()
    #značka, do ktorej sa zapíše názov zariadenia
    Label(root, textvariable=readed_name, fg="Navy").grid(column=1, row=8)
    #tlačidlo, po stlačení ktorého dôjde k odoslaniu GET požiadavky na získanie hodnoty názvu zariadenia
    Button(root, text="Čítaj názov", command=get_hostname).grid(column=1, row=9)

    #vytvorenie značky pre zadanie nového názvu zariadenia
    Label(root, text="Nový názov:").grid(column=3, row=7)
    #vytvorenie elementu pre získanie nového názvu
    Entry(root, textvariable=hostname_value, bg="LightSteelBlue").grid(column=3, row=8)
    #tlačidlo, po ktorého stlačení sa odošle PUT požiadavka na zmenu názvu zariadenia
    Button(root, text="Zmeň názov", command=set_hostname).grid(column=3, row=9)
    #vytvorenie premennej a značky, ktorá sa zobrazí po vykonaní GET/PUT požiadavky
    status = StringVar()
    Label(root, textvariable=status, fg="DarkSeaGreen").grid(column=4, row=9)

    #hlavná slučka, aby sa okno nezatvorilo po vykonaní skriptu, ale čakalo na používateľský vstup
    root.mainloop()